def vrednost_besede(beseda):
    '''Vrne vsoto in produkt vrednosti crk v besedi
       beseda je sestavljena iz crk slovenske abecede brez sumnikov'''
    # sestavimo slovar vrednosti crk
    slo_abeceda = 'abcdefghijklmnoprstuvz'
    vrednosti = {crka : ind + 1 for ind, crka in enumerate(slo_abeceda)}
    # izracunajmo produkt in vsoto
    vsota = 0
    produkt = 1
    for crka in beseda:
        vsota += vrednosti[crka]
        produkt *= vrednosti[crka]
    return vsota, produkt

def produkt(beseda):
    return vrednost_besede(beseda)[1]

def vsota(beseda):
    return vrednost_besede(beseda)[0]

vse_besede = [beseda.strip() for beseda in open('besede.txt')]
# uredimo najprej po produktu (manj pomemben kljuc)
vse_besede.sort(key = produkt)
vse_besede.sort(key = vsota)
# zapis na datoteko
pisi = open('urejene_besede2.txt', 'w')
for beseda in vse_besede:
    print(beseda, file = pisi)

# pazi 1. beseda je v tabeli na 0!
print('Kljuè: ',  vsota(vse_besede[1742]) + vsota(vse_besede[882]))